/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Mat33;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.Vec3;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.WeldJointDef;
import org.jbox2d.pooling.IWorldPool;

public class WeldJoint
extends Joint {
    private final Vec2 m_localAnchorA;
    private final Vec2 m_localAnchorB;
    private float m_referenceAngle;
    private final Vec3 m_impulse;
    private final Mat33 m_mass;

    protected WeldJoint(IWorldPool argWorld, WeldJointDef def) {
        super(argWorld, def);
        this.m_localAnchorA = new Vec2(def.localAnchorA);
        this.m_localAnchorB = new Vec2(def.localAnchorB);
        this.m_referenceAngle = def.referenceAngle;
        this.m_impulse = new Vec3();
        this.m_impulse.setZero();
        this.m_mass = new Mat33();
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.m_bodyA.getWorldPointToOut(this.m_localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float inv_dt, Vec2 argOut) {
        argOut.set(this.m_impulse.x, this.m_impulse.y);
        argOut.mulLocal(inv_dt);
    }

    @Override
    public float getReactionTorque(float inv_dt) {
        return inv_dt * this.m_impulse.z;
    }

    @Override
    public void initVelocityConstraints(TimeStep step) {
        Body bA = this.m_bodyA;
        Body bB = this.m_bodyB;
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        rA.set(this.m_localAnchorA).subLocal(bA.getLocalCenter());
        rB.set(this.m_localAnchorB).subLocal(bB.getLocalCenter());
        Mat22.mulToOut(bA.getTransform().R, rA, rA);
        Mat22.mulToOut(bB.getTransform().R, rB, rB);
        float mA = bA.m_invMass;
        float mB = bB.m_invMass;
        float iA = bA.m_invI;
        float iB = bB.m_invI;
        this.m_mass.col1.x = mA + mB + rA.y * rA.y * iA + rB.y * rB.y * iB;
        this.m_mass.col2.x = -rA.y * rA.x * iA - rB.y * rB.x * iB;
        this.m_mass.col3.x = -rA.y * iA - rB.y * iB;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = mA + mB + rA.x * rA.x * iA + rB.x * rB.x * iB;
        this.m_mass.col3.y = rA.x * iA + rB.x * iB;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = iA + iB;
        if (step.warmStarting) {
            this.m_impulse.mulLocal(step.dtRatio);
            Vec2 P = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            P.set(this.m_impulse.x, this.m_impulse.y);
            temp.set(P).mulLocal(mA);
            bA.m_linearVelocity.subLocal(temp);
            bA.m_angularVelocity -= iA * (Vec2.cross(rA, P) + this.m_impulse.z);
            temp.set(P).mulLocal(mB);
            bB.m_linearVelocity.addLocal(temp);
            bB.m_angularVelocity += iB * (Vec2.cross(rB, P) + this.m_impulse.z);
            this.pool.pushVec2(2);
        } else {
            this.m_impulse.setZero();
        }
        this.pool.pushVec2(2);
    }

    @Override
    public void solveVelocityConstraints(TimeStep step) {
        Body bA = this.m_bodyA;
        Body bB = this.m_bodyB;
        Vec2 vA = bA.m_linearVelocity;
        float wA = bA.m_angularVelocity;
        Vec2 vB = bB.m_linearVelocity;
        float wB = bB.m_angularVelocity;
        float mA = bA.m_invMass;
        float mB = bB.m_invMass;
        float iA = bA.m_invI;
        float iB = bB.m_invI;
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        rA.set(this.m_localAnchorA).subLocal(bA.getLocalCenter());
        rB.set(this.m_localAnchorB).subLocal(bB.getLocalCenter());
        Mat22.mulToOut(bA.getTransform().R, rA, rA);
        Mat22.mulToOut(bB.getTransform().R, rB, rB);
        Vec2 Cdot1 = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2.crossToOut(wA, rA, temp);
        Vec2.crossToOut(wB, rB, Cdot1);
        Cdot1.addLocal(vB).subLocal(vA).subLocal(temp);
        float Cdot2 = wB - wA;
        Vec3 Cdot = this.pool.popVec3();
        Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
        Vec3 impulse = this.pool.popVec3();
        this.m_mass.solve33ToOut(Cdot.negateLocal(), impulse);
        this.m_impulse.addLocal(impulse);
        Vec2 P = this.pool.popVec2();
        P.set(impulse.x, impulse.y);
        temp.set(P).mulLocal(mA);
        vA.subLocal(temp);
        wA -= iA * (Vec2.cross(rA, P) + impulse.z);
        temp.set(P).mulLocal(mB);
        vB.addLocal(temp);
        wB += iB * (Vec2.cross(rB, P) + impulse.z);
        bA.m_linearVelocity.set(vA);
        bA.m_angularVelocity = wA;
        bB.m_linearVelocity.set(vB);
        bB.m_angularVelocity = wB;
        this.pool.pushVec2(5);
        this.pool.pushVec3(2);
    }

    @Override
    public boolean solvePositionConstraints(float baumgarte) {
        Body bA = this.m_bodyA;
        Body bB = this.m_bodyB;
        float mA = bA.m_invMass;
        float mB = bB.m_invMass;
        float iA = bA.m_invI;
        float iB = bB.m_invI;
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        rA.set(this.m_localAnchorA).subLocal(bA.getLocalCenter());
        rB.set(this.m_localAnchorB).subLocal(bB.getLocalCenter());
        Mat22.mulToOut(bA.getTransform().R, rA, rA);
        Mat22.mulToOut(bB.getTransform().R, rB, rB);
        Vec2 C1 = this.pool.popVec2();
        C1.set(bB.m_sweep.c).addLocal(rB).subLocal(bA.m_sweep.c).subLocal(rA);
        float C2 = bB.m_sweep.a - bA.m_sweep.a - this.m_referenceAngle;
        float k_allowedStretch = 10.0f * Settings.linearSlop;
        float positionError = C1.length();
        float angularError = MathUtils.abs(C2);
        if (positionError > k_allowedStretch) {
            iA *= 1.0f;
            iB *= 1.0f;
        }
        this.m_mass.col1.x = mA + mB + rA.y * rA.y * iA + rB.y * rB.y * iB;
        this.m_mass.col2.x = -rA.y * rA.x * iA - rB.y * rB.x * iB;
        this.m_mass.col3.x = -rA.y * iA - rB.y * iB;
        this.m_mass.col1.y = this.m_mass.col2.x;
        this.m_mass.col2.y = mA + mB + rA.x * rA.x * iA + rB.x * rB.x * iB;
        this.m_mass.col3.y = rA.x * iA + rB.x * iB;
        this.m_mass.col1.z = this.m_mass.col3.x;
        this.m_mass.col2.z = this.m_mass.col3.y;
        this.m_mass.col3.z = iA + iB;
        Vec3 C = this.pool.popVec3();
        Vec3 impulse = this.pool.popVec3();
        C.set(C1.x, C1.y, C2);
        this.m_mass.solve33ToOut(C.negateLocal(), impulse);
        Vec2 P = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        P.set(impulse.x, impulse.y);
        temp.set(P).mulLocal(mA);
        bA.m_sweep.c.subLocal(temp);
        bA.m_sweep.a -= iA * (Vec2.cross(rA, P) + impulse.z);
        temp.set(P).mulLocal(mB);
        bB.m_sweep.c.addLocal(temp);
        bB.m_sweep.a += iB * (Vec2.cross(rB, P) + impulse.z);
        bA.synchronizeTransform();
        bB.synchronizeTransform();
        this.pool.pushVec2(5);
        this.pool.pushVec3(2);
        return positionError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }
}

