package br.edu.ifba.ads.mediaCenter;

public class ServidorReplicado extends Servidor{
    
    public Servidor[] servidores;
    
    public ServidorReplicado(String id){
        super(id);
        this.servidores = new Servidor[0];
    }    
    
    public long getCapacidade(){
        long capacidade = servidores[0].getCapacidade();
        for(Servidor s : this.servidores)
          if(capacidade > s.getCapacidade())
            capacidade = s.getCapacidade();
        return capacidade;
    } 
    
    public double getLatenciaEscrita(){
        double latencia = servidores[0].getLatenciaEscrita();
        for(Servidor s : this.servidores)
          if(latencia < s.getLatenciaEscrita())
            latencia = s.getLatenciaEscrita();
        return latencia;
    }  
    
    public double getLatenciaLeitura(){
        double latencia = servidores[0].getLatenciaLeitura();
        for(Servidor s : this.servidores)
          if(latencia > s.getLatenciaLeitura())
            latencia = s.getLatenciaLeitura();
        return latencia;
    }     
    
     public void ocupar(long tamanho){
        for(Servidor s : this.servidores)
          s.ocupar(tamanho);
     };   
     
     public void desocupar(long tamanho){
         for(Servidor s : this.servidores)
           s.desocupar(tamanho);
      };    
           
     
    public void addServidor(Servidor servidor){
        Servidor[] novo = new Servidor[this.servidores.length + 1];
        for(int iCont = 0; iCont < this.servidores.length; iCont++)
          novo[iCont] = this.servidores[iCont];
        novo[novo.length - 1] = servidor;
        this.servidores = novo;
    }   
    
    public String toString(){
        String str = super.toString() + "\n";
        for(Servidor s : this.servidores)
           str = str + "\t\t" + s + "@" + this.id + "\n";
        return str;   
        
    }    
    
    
}