
public class RegistroContabil{
    
    public static final int ATIVO = 1;
    public static final int PASSIVO = 2;
    public static final int PATRIMONIO_LIQUIDO = 3;    
    
    private String nomeEmpresa;
    private String cnpjEmpresa; 
    private BalancoContabil balanco;
    private LivroContabil livro;
    
    public RegistroContabil(String nomeEmpresa, String cnpjEmpresa){
        this.setNomeEmpresa(nomeEmpresa);
        this.setCNPJEmpresa(cnpjEmpresa);
        this.balanco = new BalancoContabil();
        this.livro = new LivroContabil();
    }  
    
    private void setNomeEmpresa(String nomeEmpresa){
        this.nomeEmpresa = nomeEmpresa;
    }    
    
    private void setCNPJEmpresa(String cnpjEmpresa){
        this.cnpjEmpresa = cnpjEmpresa;
    }    
    
    
    public void registrarFatoContabil(String descricao, 
                                      String nomeContaCredito, 
                                      String nomeContaDebito, 
                                      double valor){
      Conta credito = this.balanco.buscarPeloNome(nomeContaCredito);                                    
      Conta debito = this.balanco.buscarPeloNome(nomeContaDebito);      
      Lancamento lancamento = new Lancamento(descricao, credito, debito, valor);
      this.livro.registrar(lancamento);
      this.balanco.ajustar(nomeContaCredito, nomeContaDebito, valor);
    } 
    
    public void registrarNovaConta(int tipo, String nome){
        Conta conta = null;
        if(tipo == RegistroContabil.ATIVO)
          conta = new Ativo(nome);
        else if(tipo == RegistroContabil.PASSIVO)
          conta = new Passivo(nome);
        else if(tipo == RegistroContabil.PATRIMONIO_LIQUIDO)
          conta = new PatrimonioLiquido(nome);
        this.balanco.adicionar(conta);  
  
    }   
    
    public String toString(){
        String rep = this.nomeEmpresa + "---" + this.cnpjEmpresa + "\n";
        rep += "Lancamentos\n";
        rep += this.livro;
        rep += "\nBalanco\n";        
        return rep + this.balanco;
    }    
    
}
