public abstract class Servidor{
    public String id;
    
    public Servidor(String id){
        this.id = id;
    }    
    
    public boolean temCapacidade(Fragmento f){
        return this.getCapacidade() >= f.getTamanho();
    }    
    
    public abstract double getLatenciaEscrita();
    
    public double gravar(Fragmento f){
      f.setServidor(this);  
      this.ocupar(f.getTamanho());
      return f.getTamanho() * this.getLatenciaEscrita();
    };
    
    public abstract void ocupar(long tamanho); 
    
    public abstract long getCapacidade();
    
    public String toString(){
        return "Servidor [" + this.id + "]\n" +
               "\tCapacidade " + getCapacidade();
    }    
    
    
}
