public class Lancamento implements Ordenavel, JSonnable{
    private int ordem;
    private String descricao;
    private double valor;
    private Conta credito;
    private Conta debito;  
    
    
    public Lancamento(int ordem, String descricao, Conta credito, Conta debito, double valor){
        this.ordem = ordem;
        this.descricao = descricao;
        this.credito = credito;
        this.debito = debito; 
        this.valor = valor; 
    }   
    
    public int compare(Ordenavel o){
        Lancamento lancamento = (Lancamento)o;
        return lancamento.ordem - this.ordem;
    };    
    
    
    public String toString(){
        return "[" + this.ordem + "] - Descricao " + this.descricao + "\n" +
               "Valor R$" + this.valor + "\n" + 
               "Credito " + this.credito.getNome() + "\n" +
               "Debito " + this.debito.getNome();
    }
    
    
    public String[] getNomeAtributos(){
        String[] nomes = {"ordem", "descricao", "valor", "credito", "debito"};
        return nomes;
    };
    
    public String[] getValoresAtributos(){
        String[] valores = new String[5];
        valores[0] = Integer.toString(this.ordem);
        valores[1] = this.descricao;
        valores[2] = Double.toString(this.valor);
        valores[3] = this.credito.getNome();
        valores[4] = this.debito.getNome();        
        return valores;
    };    
    
    public int[] getTiposAtributos(){
        int[] tipos = {JSonnable.INT, JSonnable.STRING, JSonnable.REAL, JSonnable.STRING, JSonnable.STRING,};
        return tipos;
        
    }; 
    
   
    
}
