public class RelogioDigital implements Ordenavel{
    private int segundos;
    private int minutos;    
    private int horas;
    
    public RelogioDigital(int segundos, int minutos, int horas){
        this.setSegundos(segundos);
        this.setMinutos(minutos);
        this.setHoras(horas);        
    };  
    
    public RelogioDigital(RelogioDigital outro){
        this(outro.getSegundos(), outro.getMinutos(), outro.getHoras());
    }; 
    
    public RelogioDigital(){
        this(0, 0, 0);
    }; 
    
    public void setSegundos(int segundos){
        if(segundos >= 0 && segundos < 60)
            this.segundos = segundos;
    };   
    
    public void setMinutos(int minutos){
        if(minutos >= 0 && minutos < 60)        
            this.minutos = minutos;
    };
    
    public void setHoras(int horas){
        if(horas >= 0 && horas < 24)
            this.horas = horas;
    };    
    
    public int getSegundos(){
        return this.segundos;
    }; 
    
    public int getMinutos(){
        return this.minutos;
    }; 
    
    public int getHoras(){
        return this.horas;
    };  
    
    public int getTotalSegundos(){
        return this.getSegundos() + this.getMinutos() * 60 + this.getHoras() * 3600;
    };   
    
    public boolean isAnteMeridien(){
        return this.getHoras() >= 0 && this.getHoras() < 12;
    };    
    
    public void tick(){
        this.segundos++;
        if(this.getSegundos() > 59){
            this.setSegundos(0);
            this.minutos++;
            if(this.getMinutos() > 59){
                this.setMinutos(0);
                this.horas++;
                if(this.getHoras() > 23)
                  this.setHoras(0);
                    
            } 
        }   
    }    
    
    
    public void tick(int segundos){
        for(int iCont = 0; iCont < segundos; iCont++)
          this.tick();
    }  
    
    public String toStrStd(){
        return this.getHoras() + " : " + this.getMinutos() + " : " + this.getSegundos();
    }    
    
    public String toStrUSA(){
        String AM_PM = this.isAnteMeridien() ? "AM" : "PM";
        String strHora = "";
        
        if(this.horas >= 1 && this.horas <= 12)
            strHora += this.getHoras();
        else
           strHora += (this.getHoras() - 12 >= 0 ? this.getHoras() - 12 : - (this.getHoras() - 12));
        
        
        return strHora + " : " + this.getMinutos() + " : " + this.getSegundos() + " " + AM_PM;
    }
    
    public int compara(RelogioDigital outro){
        return this.getTotalSegundos() - outro.getTotalSegundos(); 
    } 
    
    public long compare(Ordenavel o){
        return this.compara((RelogioDigital) o);
    }    
    
    public boolean equals(RelogioDigital outro){
      return this.getTotalSegundos() == outro.getTotalSegundos();    
    }    
    
    
}
