Use AdventureWorks
GO
/* VISOES PARTICIONADAS */

--drop table Contact1;
--drop table Contact2;
--drop table Contact3;
--drop table Contact4;

/* Criacao das tabelas individuais com base no ContactID */

SELECT * INTO Contact1 FROM Person.Contact WHERE ContactID <= 5000;
SELECT * INTO Contact2 FROM Person.Contact WHERE ContactID between 5001 and 10000;
SELECT * INTO Contact3 FROM Person.Contact WHERE ContactID between 10001 and 15000;
SELECT * INTO Contact4 FROM Person.Contact WHERE ContactID between 15001 and 20000;

/* Criao das chaves primrias das tabelas individuais */

ALTER TABLE [dbo].[Contact1] ADD CONSTRAINT [PK_Contact1_ContactID] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
);
ALTER TABLE [dbo].[Contact2] ADD CONSTRAINT [PK_Contact2_ContactID] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
);
ALTER TABLE [dbo].[Contact3] ADD CONSTRAINT [PK_Contact3_ContactID] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
);
ALTER TABLE [dbo].[Contact4] ADD CONSTRAINT [PK_Contact4_ContactID] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
);

/* Criao da viso particionada */

CREATE VIEW vw_contact AS

SELECT * FROM Contact1
UNION ALL
SELECT * FROM Contact2
UNION ALL
SELECT * FROM Contact3
UNION ALL
SELECT * FROM Contact4

GO

/* Gerao do plano de execuo de uma consulta  viso particionada */

SELECT * FROM vw_contact WHERE ContactID = 5200

/* Criao das contraints de check baseadas no critrio de particionamento */

ALTER TABLE Contact1 ADD CONSTRAINT CK_Contact1_ContactID CHECK (ContactID <= 5000);
ALTER TABLE Contact2 ADD CONSTRAINT CK_Contact2_ContactID CHECK (ContactID between 5001 and 10000);
ALTER TABLE Contact3 ADD CONSTRAINT CK_Contact3_ContactID CHECK (ContactID between 10001 and 15000);
ALTER TABLE Contact4 ADD CONSTRAINT CK_Contact4_ContactID CHECK (ContactID between 15001 and 20000);

/* Planos de execuo de consultas diversas  viso particionada */

SELECT * FROM vw_contact WHERE ContactID = 5200
SELECT * FROM vw_contact WHERE ContactID <= 5200
SELECT * FROM vw_contact WHERE ContactID <= 4000
-- inserir teste com NULL
SELECT * FROM vw_contact WHERE FirstName = 'Samuel'
SELECT * FROM vw_contact WHERE ContactID <= 4000 and FirstName = 'Samuel'