USE bd_particionamento
GO

-- drop table ContactPart
-- drop partition scheme partscheme
-- drop partition function partfunc

/* Cria funcao de particionamento */

CREATE PARTITION FUNCTION partfunc (int) AS
RANGE LEFT FOR VALUES (5000,10000,15000);

/* Consulta o resultado do particionamento no catalogo */

SELECT * FROM sys.partition_range_values;

/* Cria um esquema para a particao */

CREATE PARTITION SCHEME partscheme AS
PARTITION partfunc  TO ([FG1], [FG2], [FG3], [FG4]);

/* Cria uma tabela associando-a ao esuqema de particionamento */

CREATE TABLE [dbo].[ContactPart](
	[ContactID] [int] NOT NULL,
	[Title] [nvarchar](8) NULL,
	[FirstName] [nvarchar](50) NOT NULL,
	[LastName] [nvarchar](50) NOT NULL,
	[Phone] [nvarchar](25) NULL,
	[ModifiedDate] [datetime] NOT NULL,
 CONSTRAINT [PK_ContactPart_ContactID] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
)
) ON partscheme(ContactID);

/* Consulta o resultado do particionamento no catalogo */

SELECT * FROM sys.partitions
WHERE object_id = OBJECT_ID('dbo.ContactPart');

/* Adiciona registros a tabela */

INSERT INTO ContactPart SELECT ContactID, Title, FirstName, LastName, Phone, ModifiedDate FROM AdventureWorks.Person.Contact

/* Consulta o resultado da carga na tabela ContactPart */

SELECT * FROM dbo.ContactPart

/* Consulta o resultado do particionamento no catalogo */

SELECT * FROM sys.partitions
WHERE object_id = OBJECT_ID('dbo.ContactPart');

/* Planos de execuo de consultas diversas  tabela particionada */

SELECT * FROM ContactPart WHERE ContactID > 10000
SELECT * FROM ContactPart WHERE ContactID <= 5200
SELECT * FROM ContactPart WHERE ContactID <= 4000

SELECT * FROM ContactPart WHERE FirstName = 'Samuel'
SELECT * FROM ContactPart WHERE ContactID <= 4000 and FirstName = 'Samuel'