package br.ifba.ads.inf008.imc.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

import br.ifba.ads.inf008.imc.exception.IMCException;
import br.ifba.ads.inf008.imc.model.Pessoa;

public class BDDAOPessoa implements IDAOPessoa{
	
	private final String uri = "jdbc:postgresql://localhost:5432/postgres";
	private final String selectPessoas = "SELECT nome, peso, altura FROM PESSOA";
	private final String selectPessoa = "SELECT nome, peso, altura FROM PESSOA WHERE nome = ?";
	private final String insertPessoa = "INSERT INTO PESSOA (NOME, PESO, ALTURA) VALUES (?, ?, ?)";	
	

	private Connection conn;
	private Statement stmt;
	private PreparedStatement pStmt;	
	private ResultSet rSet;
	
	public BDDAOPessoa() throws ClassNotFoundException{
		Class.forName("org.postgresql.Driver");
	}
	
	
	@Override
	public void salvar(Pessoa p) throws Exception {
		this.conn = DriverManager.getConnection(uri);
		this.pStmt = this.conn.prepareStatement(insertPessoa);
		this.pStmt.setString(1, p.getNome());
		this.pStmt.setDouble(2, p.getPeso());		
		this.pStmt.setLong(3, p.getAltura());
		this.pStmt.executeUpdate();		
		this.pStmt.close();
		this.conn.close();
	}

	@Override
	public Pessoa recuperarPeloNome(String nome) throws Exception {
		Pessoa p = null;
		
		this.conn = DriverManager.getConnection(uri);
		this.pStmt = this.conn.prepareStatement(selectPessoa);
		this.pStmt.setString(1, nome);
		this.rSet = this.pStmt.executeQuery();
		if(rSet.next()){
			p = new Pessoa();
			p.setNome(this.rSet.getString("nome"));
			p.setPeso(this.rSet.getDouble("peso"));
			p.setAltura(this.rSet.getLong("altura"));
		}
		else
			throw new IMCException(nome + " nao e um paciente cadastrado");
		this.rSet.close();
		this.pStmt.close();
		this.conn.close();
		return p;
	}

	@Override
	public Set<Pessoa> recuperarTodos() throws Exception {
		
		Set<Pessoa> pessoas = new HashSet<Pessoa>(); 
				
		Pessoa p = null;
		
		this.conn = DriverManager.getConnection(uri);
		this.pStmt = this.conn.prepareStatement(selectPessoas);
		this.rSet = this.pStmt.executeQuery();
		while(rSet.next()){
			p = new Pessoa();
			p.setNome(this.rSet.getString("nome"));
			p.setPeso(this.rSet.getDouble("peso"));
			p.setAltura(this.rSet.getLong("altura"));
			pessoas.add(p);
		}
		this.rSet.close();
		this.pStmt.close();
		this.conn.close();
		return pessoas;
	}

}
