package br.ifba.ads.inf008.imc.model;

import java.io.Serializable;

public class Pessoa implements Comparable<Pessoa>, Serializable{
	
	private String nome;
	private double peso; //kgms
	private long altura; //cms

	public Pessoa() {
		this(null, 0, 0);
	}
	
	public Pessoa(String nome, double peso, long altura) {
		super();
		this.nome = nome;
		this.peso = peso;
		this.altura = altura;
	}
	
	
	public String getNome() {
		return nome;
	}
	public void setNome(String nome) {
		this.nome = nome;
	}
	public double getPeso() {
		return peso;
	}
	public void setPeso(double peso) {
		this.peso = peso;
	}
	public long getAltura() {
		return altura;
	}
	public void setAltura(long altura) {
		this.altura = altura;
	}

	@Override
	public int compareTo(Pessoa o) {
		return this.nome.compareToIgnoreCase(o.getNome());
	}
	
	
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((nome == null) ? 0 : nome.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Pessoa other = (Pessoa) obj;
		if (nome == null) {
			if (other.nome != null)
				return false;
		} else if (!nome.equals(other.nome))
			return false;
		return true;
	}

	public String toString(){
		return this.getNome() + "[" + this.getAltura() + ", " + this.getPeso() + "]";
	}
	
	
	
}
