package br.edu.ifba.inf008.mediaCenter.persistencia;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import br.edu.ifba.inf008.mediaCenter.model.Servidor;
import br.edu.ifba.inf008.mediaCenter.model.ServidorBasico;
import br.edu.ifba.inf008.mediaCenter.model.ServidorReplicado;

public class ServidorDAOMem implements ServidorDAO{
	
	private Map<String, Servidor> servidores;
	
	public ServidorDAOMem() {
		this.servidores = new HashMap<String, Servidor>();
		this.init();
	}
	
	public void init() {
        ServidorReplicado s1 = new ServidorReplicado("anubis");
        ServidorReplicado s11 = new ServidorReplicado("thot");        
        
        s11.addServidor(new ServidorBasico("osiris", 512, 0.25, 0.25));
        s11.addServidor(new ServidorBasico("isis", 256, 0.1, 0.1));        
        
        s1.addServidor(s11);
        s1.addServidor(new ServidorBasico("bast", 512, 0.05, 0.05));
        
        this.save(new ServidorBasico("horus", 1024, 0.5, 0.8));
        this.save(new ServidorBasico("ra", 1024, 0.4, 1.0));        
        this.save(s1);        
		
	}

	public void save(Servidor servidor) {
		this.servidores.put(servidor.getId(), servidor);
	}
	
	public Collection<Servidor> findAll(){
		return this.servidores.values();
	}

}
