package br.edu.ifba.inf008.contabil.model;
import br.edu.ifba.inf008.contabil.util.Ordenavel;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public abstract  class Conta implements Ordenavel{
    private String id;
    private String nome;
    protected double saldo;
    
    public Conta(String id, String nome){
        this.setId(id);
        this.setNome(nome);
        this.saldo = 0;
    } 
    
    private void setId(String id){
        this.id = id;
    }
    
    public String getId(){
        return this.id;
    }    
    
    public double valor(){
        return this.saldo;
    }    
        
    
    private void setNome(String nome){
        this.nome = nome;
    }    
    
    public String getNome(){
        return this.nome;
    }
    
    public abstract void creditar(double valor) throws SaldoInsuficienteException;
    
    public abstract void debitar(double valor) throws SaldoInsuficienteException;
    
    public abstract String tipo();
    
    
    public boolean canDo(double valor){
    	return(valor <= this.saldo);
    }
    
    
    public String toString(){
        return "[" + this.getId() + "/" + this.tipo() + "]" + this.nome + "\t.........\t" + this.saldo; 
    } 
    
    public int compareTo(Ordenavel outra){
      return this.id.compareToIgnoreCase(((Conta)outra).id);
    }    
    
}    
