package inf008.persistencia.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import inf008.contabil.PatrimonioLiquido;
import inf008.contabil.Ativo;
import inf008.contabil.Conta;
import inf008.contabil.Passivo;
import inf008.persistencia.ContaDAO;

public class ContaDAOSQL implements ContaDAO{

	
	
	
	@Override
	public void save(Conta conta) throws Exception {
		DriverManager.registerDriver(new org.postgresql.Driver());
		Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/postgres",
													  "postgres", "");
		PreparedStatement pStmt = conn.prepareStatement("INSERT INTO CONTA(id, saldo, nome, emUso, tipo) VALUES(?, ?, ?, ?, ?)");
		
		char tipo = '\0';
		
		if(conta instanceof Ativo)
			tipo = 'A';
		else if(conta instanceof Passivo)
			tipo = 'P';
		else if(conta instanceof PatrimonioLiquido)
			tipo = 'L';
 		
		pStmt.setInt(1, conta.getId());
		pStmt.setDouble(2, conta.getSaldo());
		pStmt.setString(3, conta.getNome());
		pStmt.setBoolean(4, conta.isEmUso());
		pStmt.setString(5, Character.toString(tipo));
		pStmt.executeUpdate();
	}

	@Override
	public Conta findByName(String nome) throws Exception {
		Conta conta;
		DriverManager.registerDriver(new org.postgresql.Driver());
		Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/postgres",
													  "postgres", "");
		PreparedStatement pStmt = conn.prepareStatement("SELECT id, saldo, nome, emUso, tipo FROM conta WHERE nome = ?");
		pStmt.setString(1, nome);
		ResultSet rSet = pStmt.executeQuery();
		while(rSet.next()){
			conta = new Conta(rSet.getInt("id"), rSet.getString("nome"))
			int id = ;
			double saldo = rSet.getDouble("saldo");
			String nomeConta = ;
			boolean emUso = rSet.getBoolean("emUso");
			char tipo = rSet.getString("tipo").charAt(0);
			
		}
		rSet.close();
		pStmt.close();
		conn.close();
	}

}
