package square;
import interfaces.IPrototype;
import interfaces.Brush;

public class Square implements IPrototype
{
    public Square()
    {
        this.centerX = 0;
        this.centerY = 0;
        this.size = 10;
        this.brush = new Brush(1,1);
    }
    public Square(double centerX, double centerY, double size)
    {
        this.centerX = centerX;
        this.centerY = centerY;
        this.size = size;
    }
    public void setBrush(Brush brush)
    {
        this.brush = brush;
    }
    // Clone deep copy implementation
    public IPrototype clone()
    {
	System.out.println("Cloning a new square(" + centerX + "," + centerY + "," + size +")");
        Square clone = new Square(centerX, centerY, size);
	clone.setBrush(new Brush(brush));
	return clone;
    }
    private double centerX;
    private double centerY;
    private double size;
    private Brush brush;
}
