public class Roteiro{
    
    public static final int MAX_CIDADES = 100;
    
    private Cidade[] cidades = new Cidade[MAX_CIDADES];
    private String descricao;
    
    
    public Roteiro(String descricao){
        this.descricao = descricao;
    }    
    
    public Roteiro(String descricao, Cidade[] cidades){
        
        this.descricao = descricao;
        for(int i = 0; i < cidades.length && i < this.cidades.length; i++){
          this.cidades[i] = cidades[i];            
        }    
    }    
    
    
    public int getQtdeDiasVisitacao(){
        int qtdeDiasVisitacao = 0;
        for(Cidade cidade : this.cidades)
          qtdeDiasVisitacao += cidade.getQtdeDiasVisitacao();
        return qtdeDiasVisitacao;  
    }    
    
/*    public boolean estaPresente(Cidade cidade){
        for(Cidade c : this.cidades)
          if(c.equals(cidade))
            return true;
        return false;  
    } 
 */

    public boolean estaPresente(Cidade cidade){
        for(int i = 0; i < this.cidades.length; i++){
          Cidade c = this.cidades[i];  
          if(c != null && c.equals(cidade))
            return true;
        }    
        return false;  
    }

   
    public Cidade[] getCidadesComuns(Roteiro outro){
       Cidade[] comuns = new Cidade[Roteiro.MAX_CIDADES];
       int pos = 0;
        for(int i = 0; i < this.cidades.length; i++){
          Cidade c = this.cidades[i];  
          if(outro.estaPresente(c)){
             comuns[pos++] = c;      
           }
        }    
        return comuns;
    }
}